"""
HB_PathSelection V1.2

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_PathSelection
Description-US: Activates Edge mode and Path Selection Tool [ALT: Enables Free Path Mode]

Activates Edge-mode and selects Polygonobjects that are children of the current Object. Also sets up the Path Selection Tool. 

Name-DE: HB_PathSelection
Description-DE: Aktiviert Kanten Modus und Pfad Selektion

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=6m30s


ChangeLog:

Jun/11/2015 V1.0 
- Release Version

Nov/1/2015 V1.1
- Pathselection instead of Loop mode

Oct/11/2018 V1.2
- Modifier Alt enables Free Path Mode
- New Highres Icon

"""

import c4d
from c4d import documents, plugins

def tool():
    return c4d.plugins.GetToolData(doc, doc.GetAction())
def main():
    
    
    c4d.CallCommand(100004768) # Select Children
    for obj in doc.GetSelection():
        
        if obj.GetType()==c4d.Opolygon or  obj.GetType()==1026224:
            
            obj.SetBit(c4d.BIT_ACTIVE)
        else:
            obj.DelBit(c4d.BIT_ACTIVE)
            
    
    
    c4d.CallCommand(16351) # Edges
    c4d.CallCommand(1012129) # Path Selection
    tool()[c4d.MDATA_MWS_EDGEMODE]=2




    bc = c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):

        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==4: #ALT
            
            tool()[c4d.MDATA_MWS_EDGEMODE]=5
          
       
            

if __name__=='__main__':
    main()
    c4d.EventAdd()